<?php require_once __DIR__ . '/../config/auth.php'; require_admin();
require_once __DIR__ . '/../config/db.php'; include __DIR__ . '/../includes/header.php';
$pdo=db();
$q=trim($_GET['q']??''); $status=$_GET['status']??'';
$sql="SELECT s.*, u.name uname, u.email uemail, u.phone uphone, vc.name cat, m.name mname FROM services s
LEFT JOIN users u ON u.id=s.user_id
LEFT JOIN vehicle_categories vc ON vc.id=s.vehicle_category_id
LEFT JOIN mechanics m ON m.id=s.assigned_mechanic_id WHERE 1=1";
$params=[];
if($q!==''){
  $sql.=" AND (u.phone LIKE ? OR u.email LIKE ? OR u.name LIKE ?)";
  $params+=["%$q%","%$q%","%$q%"];
}
if($status!==''){
  $sql.=" AND s.status = ?"; $params[]=$status;
}
$sql.=" ORDER BY s.id DESC";
$stmt=$pdo->prepare($sql); $stmt->execute(array_values($params)); $rows=$stmt->fetchAll();
$mechs=$pdo->query("SELECT id,name FROM mechanics WHERE is_active=1 ORDER BY name")->fetchAll();

if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['id'])){
  $pdo->prepare("UPDATE services SET service_charge=?, parts_charge=?, additional_charge=?, status=?, assigned_mechanic_id=? WHERE id=?")
     ->execute([$_POST['service_charge']?:0, $_POST['parts_charge']?:0, $_POST['additional_charge']?:0, $_POST['status'], $_POST['assigned_mechanic_id']?:null, $_POST['id']]);
  header("Location: services.php"); exit;
}
?>
<h2>Service Requests</h2>
<form class="row g-2 mb-3">
  <div class="col-md-6">
    <div class="input-group">
      <span class="input-group-text">Search</span>
      <input class="form-control" name="q" value="<?php echo htmlspecialchars($q);?>" placeholder="Phone, email, or name">
    </div>
  </div>
  <div class="col-md-4">
    <select class="form-select" name="status">
      <option value="">All statuses</option>
      <?php foreach(['pending','in-progress','completed','rejected'] as $s): ?>
        <option value="<?php echo $s;?>" <?php if($status===$s) echo 'selected';?>><?php echo ucfirst($s);?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-2"><button class="btn btn-outline-secondary w-100">Filter</button></div>
</form>

<table class="table table-striped align-middle">
<thead><tr><th>#</th><th>Customer</th><th>Vehicle</th><th>Status</th><th>Charges</th><th>Mechanic</th><th>Save</th></tr></thead>
<tbody>
<?php foreach($rows as $r): ?>
<tr>
  <form method="post">
  <td><?php echo $r['id'];?><input type="hidden" name="id" value="<?php echo $r['id'];?>"></td>
  <td><div><?php echo htmlspecialchars($r['uname']);?></div><div class="small text-muted"><?php echo htmlspecialchars($r['uemail']);?> • <?php echo htmlspecialchars($r['uphone']);?></div></td>
  <td><?php echo htmlspecialchars($r['cat']);?>, <?php echo htmlspecialchars($r['vehicle_model']);?> <div class="small text-muted"><?php echo htmlspecialchars($r['vehicle_number']);?></div></td>
  <td>
    <select name="status" class="form-select form-select-sm">
      <?php foreach(['pending','in-progress','completed','rejected'] as $s): ?>
        <option value="<?php echo $s;?>" <?php if($r['status']===$s) echo 'selected';?>><?php echo ucfirst($s);?></option>
      <?php endforeach; ?>
    </select>
  </td>
  <td>
    <div class="input-group input-group-sm mb-1"><span class="input-group-text">Service</span><input class="form-control" name="service_charge" value="<?php echo $r['service_charge'];?>"></div>
    <div class="input-group input-group-sm mb-1"><span class="input-group-text">Parts</span><input class="form-control" name="parts_charge" value="<?php echo $r['parts_charge'];?>"></div>
    <div class="input-group input-group-sm"><span class="input-group-text">Addl.</span><input class="form-control" name="additional_charge" value="<?php echo $r['additional_charge'];?>"></div>
  </td>
  <td>
    <select class="form-select form-select-sm" name="assigned_mechanic_id">
      <option value="">Unassigned</option>
      <?php foreach($mechs as $m): ?>
        <option value="<?php echo $m['id'];?>" <?php if($r['assigned_mechanic_id']==$m['id']) echo 'selected';?>><?php echo htmlspecialchars($m['name']);?></option>
      <?php endforeach; ?>
    </select>
  </td>
  <td><button class="btn btn-sm btn-success">Save</button></td>
  </form>
</tr>
<?php endforeach; ?>
</tbody>
</table>
<?php include __DIR__ . '/../includes/footer.php'; ?>