<?php
require_once __DIR__ . '/../config/auth.php'; require_user();
require_once __DIR__ . '/../config/db.php';
include __DIR__ . '/../includes/header.php';
$pdo=db();
if($_SERVER['REQUEST_METHOD']==='POST'){
  $stmt=$pdo->prepare("INSERT INTO enquiries (user_id,subject,message) VALUES (?,?,?)");
  $stmt->execute([$_SESSION['user']['id'], $_POST['subject'], $_POST['message']]);
  echo '<div class="alert alert-success">Enquiry submitted.</div>';
}
$enqs=$pdo->prepare("SELECT * FROM enquiries WHERE user_id=? ORDER BY id DESC");
$enqs->execute([$_SESSION['user']['id']]);
$enqs=$enqs->fetchAll();
?>
<h2>New Enquiry</h2>
<form method="post" class="mb-4">
  <div class="mb-3"><label class="form-label">Subject</label><input name="subject" class="form-control" required></div>
  <div class="mb-3"><label class="form-label">Message</label><textarea name="message" class="form-control" rows="4" required></textarea></div>
  <button class="btn btn-primary">Submit</button>
</form>

<h3>My Enquiries</h3>
<table class="table table-striped">
  <thead><tr><th>#</th><th>Subject</th><th>Status</th><th>Response</th><th>Created</th></tr></thead>
  <tbody>
  <?php foreach($enqs as $e): ?>
    <tr>
      <td><?php echo $e['id']; ?></td>
      <td><?php echo htmlspecialchars($e['subject']); ?></td>
      <td><span class="badge bg-<?php echo $e['status']==='responded'?'success':'secondary'; ?>"><?php echo $e['status']; ?></span></td>
      <td><?php echo $e['admin_response'] ? htmlspecialchars($e['admin_response']) : '-'; ?></td>
      <td><?php echo $e['created_at']; ?></td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
<?php include __DIR__ . '/../includes/footer.php'; ?>