<?php
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/db.php';
include __DIR__ . '/../includes/header.php';
$pdo = db();
$cats = $pdo->query("SELECT * FROM vehicle_categories ORDER BY name")->fetchAll();
?>
<div class="hero p-5 mb-4">
  <h1 class="display-5 fw-bold">Keep your vehicle in top shape.</h1>
  <p class="lead">Book services, track status, and get transparent pricing — all in one place.</p>
  <a href="service_new.php" class="btn btn-light btn-lg">Request a Service</a>
</div>
<h2 class="mb-3">Popular Categories</h2>
<div class="row g-3">
<?php foreach ($cats as $c): ?>
  <div class="col-md-3">
    <div class="card h-100 card-hover">
      <div class="card-body">
        <h5 class="card-title"><?php echo htmlspecialchars($c['name']); ?></h5>
        <p class="card-text small text-muted"><?php echo htmlspecialchars($c['description']); ?></p>
        <a href="service_new.php?category_id=<?php echo $c['id']; ?>" class="btn btn-outline-primary btn-sm">Book now</a>
      </div>
    </div>
  </div>
<?php endforeach; ?>
</div>

<h2 class="mt-5 mb-3">Featured Services</h2>
<div class="row g-3">
  <div class="col-md-4"><div class="card h-100 card-hover"><div class="card-body"><h5>General Service</h5><p class="text-muted small">Engine oil, filters, inspection.</p></div></div></div>
  <div class="col-md-4"><div class="card h-100 card-hover"><div class="card-body"><h5>Brake & Clutch</h5><p class="text-muted small">Pads, discs, hydraulics.</p></div></div></div>
  <div class="col-md-4"><div class="card h-100 card-hover"><div class="card-body"><h5>Electrical Diagnosis</h5><p class="text-muted small">Battery, alternator, wiring.</p></div></div></div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>