<?php
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/db.php';
include __DIR__ . '/../includes/header.php';
$errors=[];
if ($_SERVER['REQUEST_METHOD']==='POST'){
    $email=trim($_POST['email']??'');
    $password=$_POST['password']??'';
    $pdo=db();
    $stmt=$pdo->prepare("SELECT * FROM users WHERE email=?");
    $stmt->execute([$email]);
    $u=$stmt->fetch();
    if($u && password_verify($password,$u['password'])){
        $_SESSION['user']=['id'=>$u['id'],'name'=>$u['name'],'email'=>$u['email']];
        header("Location: /vehicle-service-management-php/public/dashboard.php"); exit;
    } else { $errors[]="Invalid credentials"; }
}
?>
<div class="row justify-content-center">
  <div class="col-md-5">
    <h2>User Login</h2>
    <?php foreach($errors as $e):?><div class="alert alert-danger"><?php echo htmlspecialchars($e);?></div><?php endforeach;?>
    <form method="post">
      <div class="mb-3"><label class="form-label">Email</label><input type="email" name="email" class="form-control" required></div>
      <div class="mb-3"><label class="form-label">Password</label><input type="password" name="password" class="form-control" required></div>
      <button class="btn btn-primary">Login</button>
      <a class="btn btn-link" href="password_forgot.php">Forgot password?</a>
    </form>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>