<?php
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/db.php';
include __DIR__ . '/../includes/header.php';
$info='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $email=trim($_POST['email']??'');
  $pdo=db();
  $stmt=$pdo->prepare("SELECT id FROM users WHERE email=?"); $stmt->execute([$email]);
  if($stmt->fetch()){
    $token=bin2hex(random_bytes(16));
    $exp=(new DateTime('+1 hour'))->format('Y-m-d H:i:s');
    $pdo->prepare("INSERT INTO password_resets (email, token, expires_at) VALUES (?,?,?)")->execute([$email,$token,$exp]);
    $resetLink="/vehicle-service-management-php/public/password_reset.php?token=$token&email=" . urlencode($email);
    $info='<div class="alert alert-info">Reset link (demo): <a href="'.htmlspecialchars($resetLink).'">'.$resetLink.'</a></div>';
  } else {
    $info='<div class="alert alert-warning">If that email exists, a reset link will be provided.</div>';
  }
}
?>
<h2>Forgot Password</h2>
<?php echo $info; ?>
<form method="post">
  <div class="mb-3"><label class="form-label">Email</label><input type="email" name="email" class="form-control" required></div>
  <button class="btn btn-primary">Send Reset Link</button>
</form>
<?php include __DIR__ . '/../includes/footer.php'; ?>