<?php
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/db.php';
include __DIR__ . '/../includes/header.php';
$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm = $_POST['confirm'] ?? '';
    if ($password !== $confirm) $errors[] = "Passwords do not match";
    if (!$errors) {
        try {
            $pdo = db();
            $stmt = $pdo->prepare("INSERT INTO users (name,email,phone,password) VALUES (?,?,?,?)");
            $stmt->execute([$name,$email,$phone,password_hash($password, PASSWORD_BCRYPT)]);
            $_SESSION['user'] = ['id'=>$pdo->lastInsertId(),'name'=>$name,'email'=>$email];
            header("Location: /vehicle-service-management-php/public/dashboard.php"); exit;
        } catch (Exception $e) { $errors[] = "Registration failed: " . $e->getMessage(); }
    }
}
?>
<div class="row justify-content-center">
  <div class="col-md-6">
    <h2>Create Account</h2>
    <?php foreach ($errors as $e): ?><div class="alert alert-danger"><?php echo htmlspecialchars($e); ?></div><?php endforeach; ?>
    <form method="post">
      <div class="mb-3"><label class="form-label">Name</label><input name="name" class="form-control" required></div>
      <div class="mb-3"><label class="form-label">Email</label><input type="email" name="email" class="form-control" required></div>
      <div class="mb-3"><label class="form-label">Phone</label><input name="phone" class="form-control" required></div>
      <div class="mb-3"><label class="form-label">Password</label><input type="password" name="password" class="form-control" required></div>
      <div class="mb-3"><label class="form-label">Confirm Password</label><input type="password" name="confirm" class="form-control" required></div>
      <button class="btn btn-primary">Register</button>
    </form>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>